<?php
class Curso {
    private $db;
    public function __construct()
    {
        $this->db = new Database;
    }

    public function TipoIndex(){
    $this->db->query('SELECT cursos.*, especialidades.especialidad
FROM cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id
ORDER BY especialidades.especialidad,cursos.curso');
    $result = $this->db->resultSet();
    return $result;
    }

    public function TipoCuenta(){
    $this->db->query('SELECT Count(alumnos_cursos.id) AS CuentaDeid, alumnos_cursos.curso
    FROM alumnos_cursos GROUP BY alumnos_cursos.curso ORDER BY alumnos_cursos.curso');
    $result = $this->db->resultSet();

        foreach ($result as $p){
        $this->db->query('UPDATE cursos SET inscritos=:inscritos WHERE curso = :curso');
        $this->db->bind(':curso', $p->curso);
        $this->db->bind(':inscritos', $p->CuentaDeid);
        $this->db->execute();
        }

    return true;
    }


	    public function Fecha_Nota_Curso($data1){
        $this->db->query('SELECT * from notas_det WHERE curso = :cur order by fecha');
        $this->db->bind(':cur', $data1);
		$result = $this->db->resultSet();
		return $result;
    }


    public function Cur_Uniones($data){
        $this->db->query('SELECT * from cursos WHERE curso = :curso1');
        $this->db->bind(':curso1', trim($data['curso1']));
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        //return $row0;
        }else{
        $_SESSION['error_msg']="Error: Curso ".$data['curso1']." NO Existe...";
        return false;
        }

        $this->db->query('SELECT * from cursos WHERE curso = :curso2');
        $this->db->bind(':curso2', trim($data['curso2']));
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        //return $row0;
        }else{
        $_SESSION['error_msg']="Error: Curso ".$data['curso2']." NO Existe...";
        return false;
        }

        $this->db->query('UPDATE alumnos_cursos SET curso=:curso2 WHERE curso = :curso1');
        $this->db->bind(':curso1', $data['curso1']);
        $this->db->bind(':curso2', $data['curso2']);
        if($this->db->execute()){

        }else{
        $_SESSION['error_msg']="Error: Uniones no se realizaron...";
        return false;
        }

        $this->db->query('DELETE FROM cursos WHERE curso = :curso1');
        $this->db->bind(':curso1', $data['curso1']);
        if($this->db->execute()){
        //return true;
        }else{
        $_SESSION['error_msg']="Error: Uniones no se realizaron...";
        return false;
        }

        $this->TipoCuenta();
        return true;
    }

    public function IndexCur(){
    $this->db->query('SELECT cursos.id,cursos.curso,cursos.id_especialidad, especialidades.especialidad, cursos.horario, materias.materia, cursos.inicio, usuarios.apellido, usuarios.nombre
FROM ((cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) INNER JOIN materias ON cursos.id_materia = materias.id) INNER JOIN usuarios ON cursos.profesor = usuarios.rif
ORDER BY especialidades.especialidad, cursos.inicio');
    $result = $this->db->resultSet();
    return $result;
    }

    public function TipoGuardar($data){
        $this->db->query('SELECT * from materias WHERE id_especialidad = :id order by orden ASC limit 0,1');
        $this->db->bind(':id',  $data['especialidad']);
        $result = $this->db->resultSet();

        foreach ($result as $p){
        $materia=$p->id;
        }

        //var_dump($materia);
        //exit;
        $this->db->query('INSERT INTO cursos (id_especialidad,curso,id_materia,cantidad,horario,inicio,profesor) VALUES (:especialidad,:curso,:materia,:monto,:horario,:inicio,:profesor)');
        $this->db->bind(':curso', $data['curso']);
        $this->db->bind(':especialidad', $data['especialidad']);
        $this->db->bind(':monto', $data['monto']);
        $this->db->bind(':horario', $data['horario']);
        $this->db->bind(':materia', $materia);
        $this->db->bind(':inicio', $data['inicio']);
        $this->db->bind(':profesor', $data['profesor']);

        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function TipoEditar($data){
        $this->db->query('SELECT * from cursos WHERE id = :id');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

    public function Cursos_curso($data){
        $this->db->query('SELECT * from cursos WHERE curso = :id');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

    public function ReparacionBuscar(){
        $dtz = new DateTimeZone("America/Caracas");
        $dt = new DateTime("now", $dtz);
        $fecha_actual = $dt->format("Y-m-d");
        $fecha = date("Y-m-d",strtotime($fecha_actual."+ 1 day"));
    //echo $fecha;
    //exit;
    $this->db->query('SELECT * from reparaciones WHERE fecha>= :fecha and estatus="ACTIVO"');
//    $this->db->query('SELECT * from reparaciones WHERE estatus="ACTIVO"');
    $this->db->bind(':fecha', $fecha);
    $result = $this->db->resultSet();
    return $result;
    }

public function CursosBuscarFecha(){
$dtz = new DateTimeZone("America/Caracas");
$dt = new DateTime("now", $dtz);
$fecha_actual = $dt->format("Y-m-d");
$fecha = date("Y-m-d",strtotime($fecha_actual."- 1 day"));

    $this->db->query('SELECT * from cursos WHERE inicio>= :fecha');
    $this->db->bind(':fecha', $fecha);
    $result = $this->db->resultSet();
    return $result;
}

public function CursosBuscarEst($curso){
/*$dtz = new DateTimeZone("America/Caracas");
$dt = new DateTime("now", $dtz);
$fecha_actual = $dt->format("Y-m-d");
$fecha = date("Y-m-d",strtotime($fecha_actual."- 2 day"));*//*  */

$this->db->query('SELECT pagos.curso, pagos.fecha, Count(pagos.id) AS CuentaDeid
FROM pagos GROUP BY pagos.curso, pagos.fecha HAVING pagos.curso=:curso ORDER BY pagos.curso, pagos.fecha');
$this->db->bind(':curso', $curso);
$result = $this->db->resultSet();
return $result;
}

public function CursosBuscarEst2($curso){
$this->db->query('SELECT COUNT(cedula) as cuenta from alumnos_cursos where curso=:curso');
$this->db->bind(':curso', $curso);
        $row0 = $this->db->single();
        return $row0;
}

    public function Fecha_Nota($data1,$data2){
    //echo $data1,$data2;
    //exit;
        $this->db->query('SELECT * from notas_det WHERE curso = :cur AND id_materia= :mat');
        $this->db->bind(':cur', $data1);
        $this->db->bind(':mat', $data2);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

public function TipoBuscar($data){
$this->db->query('SELECT cursos.*, especialidades.especialidad, materias.materia, materias.codigo
FROM (cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) INNER JOIN materias ON cursos.id_materia = materias.id
WHERE cursos.curso=:id');

        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
}

    public function TipoAct($data){
        $this->db->query('UPDATE cursos SET id_especialidad=:especialidad,cantidad=:monto,horario=:horario,inicio=:inicio,profesor=:profesor WHERE curso = :curso');
        $this->db->bind(':curso', $data['curso']);
        $this->db->bind(':especialidad', $data['especialidad']);
        $this->db->bind(':monto', $data['monto']);
        $this->db->bind(':horario', $data['horario']);
        $this->db->bind(':inicio', $data['inicio']);
        $this->db->bind(':profesor', $data['profesor']);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function TipoDelete($id){
/*        echo $id;
        EXIT;
        $this->db->query('SELECT * FROM citasevaluaciones WHERE id = :id ');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        $fila=$row->cod_eval;*/

    $this->db->query('INSERT INTO alumnos_cursos_baja (cedula,alumno,curso,solvente,id_materia)
    SELECT cedula,alumno,curso,solvente,id_materia FROM alumnos_cursos WHERE alumnos_cursos.curso=:id');
    $this->db->bind(':id', $id);
        if($this->db->execute()){
        //return true;
        }else{
        return false;
        }

        $this->db->query('DELETE FROM alumnos_cursos WHERE curso = :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
        //return true;
        }else{
        return false;
        }

        $this->db->query('SELECT * FROM alumnos_cursos WHERE curso = :id ');
        $this->db->bind(':id', $id);
        $result = $this->db->resultSet();
        if($result){
        return false;
        exit;
        }

        $this->db->query('DELETE FROM cursos WHERE curso = :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }

    }

    public function ProfAsDel($id){
        $this->db->query('DELETE FROM asistencia WHERE id = :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
        //return true;
        }else{
        return false;
        }
        $this->db->query('DELETE FROM asistencia_det WHERE id_asistencia = :id');
        $this->db->bind(':id', $id);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function ProfTipoIndex($id){
//    $this->db->query('SELECT cursos.*, especialidades.especialidad
//FROM cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id WHERE cursos.profesor=:id
//ORDER BY cursos.inicio DESC');

$this->db->query('SELECT cursos.curso, especialidades.especialidad, cursos.horario, materias.materia, cursos.profesor
FROM (cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) INNER JOIN materias ON cursos.id_materia = materias.id
WHERE (((cursos.profesor)=:id)) ORDER BY especialidades.especialidad');

$this->db->bind(':id', $id);
    $result = $this->db->resultSet();
    return $result;
    }

    public function ProfTipoBuscar($data,$ced){
$this->db->query('SELECT cursos.curso,cursos.id_materia,cursos.id_especialidad, especialidades.especialidad, cursos.horario, materias.materia, materias.codigo, cursos.profesor
FROM (cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) INNER JOIN materias ON cursos.id_materia = materias.id
WHERE cursos.curso=:id and cursos.profesor=:ced ORDER BY especialidades.especialidad');
        $this->db->bind(':id', $data);
        $this->db->bind(':ced', $ced);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

     public function ProfTipoBuscar0($data){
$this->db->query('SELECT cursos.curso,cursos.id_materia,cursos.id_especialidad, especialidades.especialidad, cursos.horario, materias.materia, materias.codigo, cursos.profesor
FROM (cursos INNER JOIN especialidades ON cursos.id_especialidad = especialidades.id) INNER JOIN materias ON cursos.id_materia = materias.id
WHERE cursos.curso=:id ORDER BY especialidades.especialidad');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

     public function Mat_Avanzar($cur,$mat){
        $this->db->query('UPDATE cursos SET id_materia=:materia WHERE curso = :id');
        $this->db->bind(':id', $cur);
        $this->db->bind(':materia', $mat);
        if($this->db->execute()){
        return true;
        }else{
        return false;
        }
    }

    public function Mat_Buscar($data){
        $this->db->query('SELECT * from notas WHERE cedula = :data0');
        $this->db->bind(':data0', $data);
        $result = $this->db->resultSet();
        if($result){
        return $result;
        }else{
        return false;
        }
   }

public function ProfGuardarAs($data,$data0){
$this->db->startTransaction();
        $this->db->query('INSERT INTO asistencia(curso,cod_materia,fecha) VALUES (:curso,:cod_materia,:fecha)');
        $this->db->bind(':fecha', $data0['fecha']);
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':cod_materia', $data0['cod_materia']);
        //$this->db->execute();
        $id_asistencia = $this->db->executelast();

//    var_dump($dataa);
//exit;
        $this->db->query('INSERT INTO asistencia_det(id_asistencia,cedula,curso,cod_materia,dia1) VALUES (:id_asistencia,:cedula,:curso,:cod_materia,:dia1)');
        foreach ($data as $datax){
        $this->db->bind(':id_asistencia', $id_asistencia);
        $this->db->bind(':cedula', $datax['cedula']);
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':cod_materia', $data0['cod_materia']);
        $this->db->bind(':dia1', $datax['asiste']);
        $this->db->execute();
        }

    if($this->db->submitTransaction()){
    return true;
    }else{
    return false;
    }
}

public function ProfGuardarAsDet($data,$data0){
$this->db->startTransaction();
/*        $this->db->query('INSERT INTO asistencia(curso,cod_materia,fecha) VALUES (:curso,:cod_materia,:fecha)');
        $this->db->bind(':fecha', $data0['fecha']);
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':cod_materia', $data0['cod_materia']);
        //$this->db->execute();
        $id_asistencia = $this->db->executelast();*/

//    var_dump($dataa);
//exit;
        foreach ($data as $datax){
        if($datax['idf']==0){
        $this->db->query('INSERT INTO asistencia_det(id_asistencia,cedula,curso,cod_materia,dia1) VALUES (:id_asistencia,:cedula,:curso,:cod_materia,:dia1)');
        $this->db->bind(':id_asistencia', $data0['ida']);
        $this->db->bind(':cedula', $datax['cedula']);
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':cod_materia', $data0['cod_materia']);
        $this->db->bind(':dia1', $datax['asiste']);
        $this->db->execute();
        }else{
        $this->db->query('UPDATE asistencia_det SET curso=:curso,cod_materia=:cod_materia,dia1=:dia1 WHERE id=:id_asistencia');
        $this->db->bind(':id_asistencia', $datax['idf']);
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':cod_materia', $data0['cod_materia']);
        $this->db->bind(':dia1', $datax['asiste']);
        $this->db->execute();
        }
        }

    if($this->db->submitTransaction()){
    return true;
    }else{
    return false;
    }
}

public function GuardarNt($data,$data0){

//var_dump($data0);
//exit;

        foreach ($data['ced'] as $key =>$ced){
        //echo $ced.' /// '.$key.'==='.$data['nota'][$key].'<br>';
        $cedula=$ced;
        $notas=$data['nota'][$key];
        if($notas==99 or strlen(trim($notas))==0){
        }else{
        //if(strlen(trim($notas))==0){
        //$notas=null;
        //}


        $dataa[] = [
        'cedula' => $cedula,
        'curso' => $data['curso'],
        'nota' => $notas,
        'cod_materia' => $data['materia'],
        'id_materia' => $data['idmateria'],
        'fecha' => $data['fecha'],
        ];

        }
        }
//echo '<br><br><br><br><br><br>';
//var_dump($dataa);
//exit;
$this->db->startTransaction();

        $this->db->query('DELETE FROM notas WHERE cedula=:cedula and cod_materia=:cod_materia');
        foreach ($dataa as $valor){
        //echo $ced.' /// '.$key.'==='.$data['nota'][$key].'<br>';
        //echo $valor['cod_materia'];
        $ced=$valor['cedula'];
        $mat=$valor['cod_materia'];
        $imat=$valor['id_materia'];
        $fec=$valor['fecha'];
        $cur=$valor['curso'];

        $this->db->bind(':cedula', $ced);
        $this->db->bind(':cod_materia', $mat);
        $this->db->execute();
        }

        $this->db->query('DELETE FROM notas_det WHERE curso=:curso AND id_materia=:id_materia');
        $this->db->bind(':curso', $cur);
        $this->db->bind(':id_materia', $imat);
        $this->db->execute();

        $this->db->query('INSERT INTO notas_det(curso,cod_materia,id_materia,fecha) VALUES (:curso,:cod_materia,:id_materia,:fecha)');
        $this->db->bind(':curso', $cur);
        $this->db->bind(':cod_materia', $mat);
        $this->db->bind(':id_materia', $imat);
        $this->db->bind(':fecha', $fec);
        $this->db->execute();

        $this->db->query('INSERT INTO notas(cedula,curso,cod_materia,id_materia,nota,fecha) VALUES (:cedula,:curso,:cod_materia,:id_materia,:nota,:fecha)');
        foreach ($dataa as $datax){
        $this->db->bind(':cedula', $datax['cedula']);
        $this->db->bind(':curso', $datax['curso']);
        $this->db->bind(':cod_materia', $datax['cod_materia']);
        $this->db->bind(':id_materia', $datax['id_materia']);
        $this->db->bind(':nota', $datax['nota']);
        $this->db->bind(':fecha', $datax['fecha']);
        $this->db->execute();
        }

        $this->db->query('UPDATE cursos SET id_materia=:id_materia WHERE curso = :curso');
        $this->db->bind(':curso', $data0['curso']);
        $this->db->bind(':id_materia', $data0['id_materia']);
        $this->db->execute();

        $this->db->query('UPDATE alumnos_cursos SET id_materia=:cod_materia WHERE cedula=:cedula and curso=:curso');
        foreach ($dataa as $datax){
        if($datax['nota']>13){
            $this->db->bind(':cedula', $datax['cedula']);
            $this->db->bind(':curso', $datax['curso']);
            $this->db->bind(':cod_materia', $data0['id_materia']);
            $this->db->execute();
        }
        }



if($this->db->submitTransaction()){
return true;
}else{
return false;
}
}

public function GuardarNtProf($data){

$this->db->startTransaction();
        $this->db->query('UPDATE presentan_si set apreciativa=:apreciativa,nota=:nota WHERE id=:idd');
        foreach ($data['ced'] as $key =>$ced){
        //echo $ced.' /// '.$key.'==='.$data['nota'][$key].'<br>';
        $cedula=$ced;
        $notas=$data['nota'][$key];
        $aprec=$data['apreciativa'][$key];

        if(strlen(trim($notas))>0){
        $this->db->bind(':idd', $cedula);
        $this->db->bind(':nota', $notas);
        $this->db->bind(':apreciativa', $aprec);
        $this->db->execute();
        }
        }

if($this->db->submitTransaction()){
return true;
}else{
return false;
}
//echo '<br><br><br><br><br><br>';
//var_dump($dataa);
//exit;

}


    public function ProfMat($data){
        $this->db->query('SELECT * from materias WHERE id = :id');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

    public function ProfBuscar($data){
        $this->db->query('SELECT * from usuarios WHERE rif = :id');
        $this->db->bind(':id', $data);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
    }

    public function ProfMatNt($data0,$data1){
    //echo $data0.' - '.$data1;
    //exit;

        $this->db->query('SELECT * from notas WHERE cedula = :data0 and cod_materia=:data1');
        $this->db->bind(':data0', $data0);
        $this->db->bind(':data1', $data1);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
   }

   public function ProfMatAs($data0,$data1){
        $this->db->query('SELECT * from asistencia WHERE curso = :data0 and cod_materia=:data1');
        $this->db->bind(':data0', $data0);
        $this->db->bind(':data1', $data1);
        $result = $this->db->resultSet();
        return $result;
   }

   public function ProfMatAs0($data0){
        $this->db->query('SELECT * from asistencia WHERE id = :data0');
        $this->db->bind(':data0', $data0);
        $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
   }

   public function ProfMatAsDet0($data0){
        $this->db->query('SELECT * from asistencia_det WHERE id_asistencia = :data0');
        $this->db->bind(':data0', $data0);
        $result = $this->db->resultSet();
        return $result;
   }

   public function ProfMatAsDet($data0,$data1){
        $this->db->query('SELECT * from asistencia_det WHERE id_asistencia=:data0 and cedula=:data1');
        $this->db->bind(':data0', $data0);
        $this->db->bind(':data1', $data1);
        //$result = $this->db->resultSet();
        //return $result;
                $row0 = $this->db->single();
        if($this->db->rowCount() > 0){
        return $row0;
        }else{
        return false;
        }
   }

    public function buscar_notas($data){
        $this->db->query('SELECT * from notas WHERE curso = :data order by cedula,id_materia');
        $this->db->bind(':data', $data);
        $result = $this->db->resultSet();
        //return $result;

       var_dump($result);
       exit;

        $this->db->query('UPDATE alumnos_cursos set id_materia=:id_materia WHERE cedula=:cedula and curso=:curso');
        foreach ($result as $notas){
        $this->db->bind(':cedula', $notas->cedula);
        $this->db->bind(':curso', $notas->curso);
        $this->db->bind(':id_materia', $notas->id_materia);
        $this->db->execute();
        }
    }

public function VerificaMateria($data,$mat,$curso){

$array_mat=json_decode(json_encode($data), TRUE);

//echo count($array_mat);
$mat_antes=$mat;
for ($i = 0; $i < count($array_mat); $i++) {
    $mat_id=$array_mat[$i]['id'];
    //echo $mat_id.' == '.$mat.'<br>';
    if($mat_id==$mat){
    $mat_antes=$array_mat[$i]['materia'];
                if($i-1>=0){
                $mat_antes=$array_mat[$i-1]['id'];
                }
    }
}
//echo $curso.'  '.$mat_antes;

$this->db->query('SELECT * from notas WHERE curso = :cur and id_materia= :mat');
$this->db->bind(':cur', $curso);
$this->db->bind(':mat', $mat_antes);
$result = $this->db->resultSet();

        foreach ($result as $p){
        if($p->nota >= 14){
        $this->db->query('UPDATE alumnos_cursos SET id_materia=:id_materia WHERE cedula= :cedula and curso = :curso');
        //echo $p->cedula.' '.$p->curso.' '.$p->nota.' '.$mat.'<br>';
        $this->db->bind(':cedula', $p->cedula);
        $this->db->bind(':curso', $p->curso);
        $this->db->bind(':id_materia', $mat);
        //$this->db->execute();
        if($this->db->execute()){
        //echo 'bien';
        }else{
        //echo 'mal';
        }

        }
        }
//var_dump($result);

//exit;
}

}